#include <allegro.h>
#include <math.h>

#include "main.h"
#include "actor.h"
#include "sectors.h"
#include "draw.h"
#include "shot.h"
#include "man.h"
#include "station.h"
#include "alienship.h"
#include "game.h"
#include "sfx.h"

ACTOR alienship;

float alienship0_points[] = {
	   -17.000,     -3.000, // 0
	    14.000,     -3.000, // 1
	    14.000,    -11.000, // 2
	    24.000,    -13.000, // 3
	    25.000,     -3.000, // 4
	   -18.000,    -10.000, // 5
	   -26.000,    -12.000, // 6
	   -26.000,     -1.000, // 7
	   -70.000,     34.000, // 8
	    72.000,     35.000, // 9
	   -20.000,     67.000, // 10
	     0.000,     91.000, // 11
	    24.000,     69.000, // 12
	    -6.000,     71.000, // 13
	   -13.000,     62.000, // 14
	     5.000,     72.000, // 15
	    12.000,     63.000, // 16
	   -62.000,     83.000, // 17
	    64.000,     81.000, // 18
	    -4.000,     49.000, // 19
	     8.000,     50.000, // 20
	    73.000,     95.000, // 21
	    81.000,     79.000, // 22
	   -77.000,     87.000, // 23
	   -66.000,     98.000, // 24
	     0.000,     28.000, // 25
	   -33.000,     21.000, // 26
	    33.000,     22.000, // 27
	    75.000,     50.000, // 28
	    84.000,     36.000, // 29
	   -71.000,     52.000, // 30
	   -84.000,     35.000  // 31
};
int alienship0_lines[] = {
	7, 6, 0, 0, 0,
	6, 5, 0, 0, 0,
	5, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 4, 0, 0, 0,
	9, 4, 0, 0, 0,
	7, 8, 0, 0, 0,
	12, 11, 0, 0, 0,
	11, 10, 0, 0, 0,
	14, 13, 0, 0, 0,
	16, 15, 0, 0, 0,
	12, 18, 0, 0, 0,
	10, 17, 0, 0, 0,
	19, 20, 0, 0, 0,
	25, 10, 0, 0, 0,
	25, 12, 0, 0, 0,
	27, 26, 0, 0, 0,
	26, 8, 0, 0, 0,
	27, 9, 0, 0, 0,
	26, 10, 0, 0, 0,
	27, 12, 0, 0, 0,
	23, 24, 252, 252, 0,
	23, 17, 252, 252, 0,
	17, 24, 252, 252, 0,
	18, 21, 252, 252, 0,
	18, 22, 252, 252, 0,
	22, 21, 252, 252, 0,
	8, 31, 0, 252, 252,
	8, 30, 0, 252, 252,
	30, 31, 0, 252, 252,
	9, 28, 0, 252, 252,
	9, 29, 0, 252, 252,
	29, 28, 0, 252, 252 
};
float alienship1_points[] = {
	   -17.000,     -3.000, // 0
	    14.000,     -3.000, // 1
	    12.000,    -12.000, // 2
	    21.000,    -14.000, // 3
	    25.000,     -3.000, // 4
	   -17.000,    -11.000, // 5
	   -25.000,    -12.000, // 6
	   -26.000,     -1.000, // 7
	   -68.000,     33.000, // 8
	    71.000,     33.000, // 9
	   -20.000,     67.000, // 10
	     0.000,     91.000, // 11
	    24.000,     69.000, // 12
	    -6.000,     71.000, // 13
	   -11.000,     61.000, // 14
	     5.000,     72.000, // 15
	    13.000,     64.000, // 16
	   -60.000,     82.000, // 17
	    65.000,     82.000, // 18
	    -4.000,     50.000, // 19
	     8.000,     50.000, // 20
	    73.000,     95.000, // 21
	    81.000,     79.000, // 22
	   -77.000,     87.000, // 23
	   -65.000,     98.000, // 24
	     0.000,     28.000, // 25
	   -33.000,     21.000, // 26
	    33.000,     22.000, // 27
	    75.000,     50.000, // 28
	    86.000,     33.000, // 29
	   -75.000,     51.000, // 30
	   -84.000,     36.000  // 31
};
int alienship1_lines[] = {
	7, 6, 0, 0, 0,
	6, 5, 0, 0, 0,
	5, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 4, 0, 0, 0,
	9, 4, 0, 0, 0,
	7, 8, 0, 0, 0,
	12, 11, 0, 0, 0,
	11, 10, 0, 0, 0,
	14, 13, 0, 0, 0,
	16, 15, 0, 0, 0,
	12, 18, 0, 0, 0,
	10, 17, 0, 0, 0,
	19, 20, 0, 0, 0,
	25, 10, 0, 0, 0,
	25, 12, 0, 0, 0,
	27, 26, 0, 0, 0,
	26, 8, 0, 0, 0,
	27, 9, 0, 0, 0,
	26, 10, 0, 0, 0,
	27, 12, 0, 0, 0,
	18, 22, 0, 252, 0,
	18, 21, 0, 252, 0,
	21, 22, 0, 252, 0,
	17, 23, 0, 252, 0,
	24, 23, 0, 252, 0,
	17, 24, 0, 252, 0,
	8, 30, 252, 0, 0,
	8, 31, 252, 0, 0,
	31, 30, 252, 0, 0,
	9, 28, 252, 0, 0,
	9, 29, 252, 0, 0,
	29, 28, 252, 0, 0 
};

float alienshipdead_points[] = {
	   -17.000,     -3.000, // 0
	    14.000,     -3.000, // 1
	    12.000,    -12.000, // 2
	    21.000,    -14.000, // 3
	    25.000,     -3.000, // 4
	   -17.000,    -11.000, // 5
	   -25.000,    -12.000, // 6
	   -26.000,     -1.000, // 7
	   -64.000,      2.000, // 8
	    57.000,     -2.000, // 9
	   -20.000,     31.000, // 10
	    -1.000,     55.000, // 11
	    24.000,     35.000, // 12
	    -4.000,     34.000, // 13
	   -12.000,     27.000, // 14
	     7.000,     35.000, // 15
	    12.000,     25.000, // 16
	   -57.000,     16.000, // 17
	    58.000,     14.000, // 18
	    -5.000,     12.000, // 19
	     7.000,     15.000, // 20
	    67.000,     -3.000, // 21
	    55.000,     -3.000, // 22
	   -52.000,      0.000, // 23
	   -67.000,     -1.000, // 24
	     1.000,     -8.000, // 25
	   -33.000,     21.000, // 26
	    33.000,     22.000, // 27
	    65.000,    -16.000, // 28
	    53.000,    -17.000, // 29
	   -76.000,     -8.000, // 30
	   -63.000,    -10.000  // 31
};
int alienshipdead_lines[] = {
	7, 6, 0, 0, 0,
	6, 5, 0, 0, 0,
	5, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 4, 0, 0, 0,
	9, 4, 0, 0, 0,
	7, 8, 0, 0, 0,
	12, 11, 0, 0, 0,
	11, 10, 0, 0, 0,
	14, 13, 0, 0, 0,
	16, 15, 0, 0, 0,
	12, 18, 0, 0, 0,
	10, 17, 0, 0, 0,
	19, 20, 0, 0, 0,
	25, 10, 0, 0, 0,
	25, 12, 0, 0, 0,
	27, 26, 0, 0, 0,
	26, 8, 0, 0, 0,
	27, 9, 0, 0, 0,
	26, 10, 0, 0, 0,
	27, 12, 0, 0, 0,
	18, 22, 0, 252, 0,
	18, 21, 0, 252, 0,
	21, 22, 0, 252, 0,
	17, 23, 0, 252, 0,
	24, 23, 0, 252, 0,
	17, 24, 0, 252, 0,
	8, 30, 252, 0, 0,
	8, 31, 252, 0, 0,
	31, 30, 252, 0, 0,
	9, 28, 252, 0, 0,
	9, 29, 252, 0, 0,
	29, 28, 252, 0, 0 
};


void alienship_process(void)
{
	int oldsector, newsector;
	float kx = 0, ky = 0;
	ACTOR *actor = &alienship;
	
	if (actor->health < 0) {
		if (actor->frame < 2) {
			actor->frame = 2;
			actor->anim = 0;
			alienship.dx = 0;
			alienship.dy = 0;
		}
		if (actor->y > 0) actor->y--;
		if (actor->anim < 64) actor->anim++;
		return;
	}
	
	if (key[KEY_RIGHT]) kx = 1;
	if (key[KEY_LEFT]) kx = -1;
	if (key[KEY_UP]) ky = 1;
	if (key[KEY_DOWN]) ky = -1;

	if (actor->timer) actor->timer--;
	
	if (key[KEY_RCONTROL]) {
		if (actor->timer == 0 && ammo > 0) {
			ACTOR *shot;
			shot = shot_init();
			if (shot) {
				int rx = rand() >> 10;
				if (sound_on) play_sample(sfx_fire, 100, 128, 900 + (rand() & 127), 0);
				rx &= 1;
				rx *= 51;
				rx -= 25;
				ammo--;
				if (ammo) ammo--;
				shot->x = actor->x + rx;
				shot->y = actor->y - 10;
				shot->dx = actor->dx * 0.8;
				shot->dy = actor->dy * 0.8 - 10;
				actor->timer = 9;
			}
		}
	}
	
	actor->dx += kx * 0.5;
	actor->dy += ky * 0.5 - 0.1;
	actor->dx *= 0.98;
	actor->dy *= 0.98;
	
	oldsector = sector_get(actor->x);
	if (actor->y > 3000) oldsector = -1;
	
	actor->x += actor->dx;
	
	if (actor_collide(actor, &station)) {
		actor->x -= actor->dx;
		actor->dx = -actor->dx;
	}
	
	actor->y += actor->dy;
	if (actor->y + actor->b < 0) {
		int sp = 10 * (actor->dx * actor->dx + actor->dy * actor->dy);
		actor->y = -actor->b;
		actor->dy = -actor->dy;
		if (sp > 20) {
			actor->health -= sp;
			if (sound_on) play_sample(sfx_damage, 100 + MAX(sp, 100), 128, 900 + (rand() & 127), 0);
		}
	}
	if (actor_collide(actor, &station)) {
		int sp = actor->dx * actor->dx + actor->dy * actor->dy;
		actor->y -= actor->dy;
		actor->dy = -actor->dy;
		if (sp > 20) actor->health -= sp / 10.0; else {
			if (ammo < 1000) {
				ammo++;
				if (sound_on) play_sample(sfx_refuel, 50, 128, 900 + (rand() & 127), 0);
			}
			if (actor->health < 1000) actor->health++;
		}
	}
	
	newsector = sector_get(actor->x);
	if (actor->y > 3000) newsector = -1;
	
	if (oldsector != newsector && newsector >= 0) {
		sector_wake_up_mans(newsector);
		sector_wake_up_mans(newsector - 1);
		sector_wake_up_mans(newsector + 1);
	}
	
	if (actor->x > SECTORS * SECTOR_DIMENSION)
		actor->x -= SECTORS * SECTOR_DIMENSION;
		
	if (actor->x < 0)
		actor->x += SECTORS * SECTOR_DIMENSION;

	actor->anim++;
	if (actor->anim == 8) {
		actor->anim = 0;
		actor->frame++;
		if (actor->frame == 2) actor->frame = 0;
	}

	{
		int m;
		for (m = 0; m < mans_num; m++) {
			if (actor_inside(actor, man[m]) && !man[m]->hit) {
				int sp = sqrt(actor->dx * actor->dx + actor->dy * actor->dy);
				actor->health -= sp;		
				if (sound_on) play_sample(sfx_damage, 100 + MAX(sp, 100), 128, 900 + (rand() & 127), 0);
				if (man[m]->hit == 0 && man[m]->type == 0) population--;
				if (man[m]->hit == 0 && man[m]->type == 2) population--;
				if (man[m]->hit == 0 && man[m]->type == 3) population -= 100;
				man[m]->hit = 1;
				actor->dx = -actor->dx;
				actor->dy = -actor->dy;
			}
		}
	}
}

static void alienship_draw(ACTOR *actor, int x, int y)
{
	if (actor->frame == 0) draw_(x, y, points(alienship0), lines(alienship0), alienship0_points, alienship1_points, alienship0_lines, actor->anim / 8.0);
	if (actor->frame == 1) draw_(x, y, points(alienship1), lines(alienship1), alienship1_points, alienship0_points, alienship1_lines, actor->anim / 8.0);
	if (actor->frame == 2) draw_(x, y, points(alienship1), lines(alienship1), alienship1_points, alienshipdead_points, alienship1_lines, actor->anim / 64.0);
}

ACTOR *alienship_init(void)
{
	ACTOR *actor = &alienship;
	actor_init(actor);
	bound_(points(alienship0), alienship0_points, &(actor->l), &actor->t, &actor->r, &actor->b);
	actor->draw = alienship_draw;
	color_(lines(alienship0), alienship0_lines);
	color_(lines(alienship1), alienship1_lines);
	
	return actor;
}
